/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.progwidgets;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import me.desht.pneumaticcraft.api.drone.ProgWidgetType;
import me.desht.pneumaticcraft.common.core.ModProgWidgets;
import me.desht.pneumaticcraft.common.progwidgets.IProgWidget;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidget;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;

public class ProgWidgetLiquidFilter
extends ProgWidget {
    private Fluid fluid = Fluids.f_76191_;

    public ProgWidgetLiquidFilter() {
        super((ProgWidgetType)((Object)ModProgWidgets.LIQUID_FILTER.get()));
    }

    public static ProgWidgetLiquidFilter withFilter(Fluid fluid) {
        ProgWidgetLiquidFilter f = new ProgWidgetLiquidFilter();
        f.setFluid(fluid);
        return f;
    }

    @Override
    public void addErrors(List<Component> curInfo, List<IProgWidget> widgets) {
        super.addErrors(curInfo, widgets);
        if (this.fluid == Fluids.f_76191_) {
            curInfo.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.progWidget.liquidFilter.error.noLiquid", new Object[0]));
        }
    }

    @Override
    public boolean hasStepInput() {
        return false;
    }

    @Override
    public ProgWidgetType<?> returnType() {
        return (ProgWidgetType)((Object)ModProgWidgets.LIQUID_FILTER.get());
    }

    @Override
    public List<ProgWidgetType<?>> getParameters() {
        return ImmutableList.of((Object)((Object)((ProgWidgetType)((Object)ModProgWidgets.LIQUID_FILTER.get()))));
    }

    @Override
    public ResourceLocation getTexture() {
        return Textures.PROG_WIDGET_LIQUID_FILTER;
    }

    @Override
    public void readFromNBT(CompoundTag tag) {
        super.readFromNBT(tag);
        this.fluid = tag.m_128441_("fluid") ? (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(tag.m_128461_("fluid"))) : Fluids.f_76191_;
    }

    @Override
    public void writeToNBT(CompoundTag tag) {
        super.writeToNBT(tag);
        if (this.fluid != Fluids.f_76191_) {
            tag.m_128359_("fluid", this.fluid.getRegistryName().toString());
        }
    }

    @Override
    public void writeToPacket(FriendlyByteBuf buf) {
        super.writeToPacket(buf);
        buf.writeFluidStack(new FluidStack(this.fluid, 1000));
    }

    @Override
    public void readFromPacket(FriendlyByteBuf buf) {
        super.readFromPacket(buf);
        this.fluid = buf.readFluidStack().getFluid();
    }

    @Override
    public void getTooltip(List<Component> curTooltip) {
        super.getTooltip(curTooltip);
        if (this.fluid != null) {
            curTooltip.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.fluid", new Object[0]).m_130940_(ChatFormatting.AQUA).m_7220_(this.asTextComponent()));
        }
    }

    private boolean isLiquidValid(Fluid fluid) {
        return this.fluid == null || fluid == this.fluid;
    }

    public static boolean isLiquidValid(Fluid fluid, IProgWidget mainWidget, int filterIndex) {
        ProgWidgetLiquidFilter widget = (ProgWidgetLiquidFilter)mainWidget.getConnectedParameters()[mainWidget.getParameters().size() + filterIndex];
        while (widget != null) {
            if (!widget.isLiquidValid(fluid)) {
                return false;
            }
            widget = (ProgWidgetLiquidFilter)widget.getConnectedParameters()[0];
        }
        widget = (ProgWidgetLiquidFilter)mainWidget.getConnectedParameters()[filterIndex];
        if (widget == null) {
            return true;
        }
        while (widget != null) {
            if (widget.isLiquidValid(fluid)) {
                return true;
            }
            widget = (ProgWidgetLiquidFilter)widget.getConnectedParameters()[0];
        }
        return false;
    }

    public static boolean isLiquidValid(Fluid fluid, List<ProgWidgetLiquidFilter> whitelist, List<ProgWidgetLiquidFilter> blacklist) {
        for (ProgWidgetLiquidFilter filter : blacklist) {
            if (filter.isLiquidValid(fluid)) continue;
            return false;
        }
        if (whitelist.size() == 0) {
            return true;
        }
        for (ProgWidgetLiquidFilter filter : whitelist) {
            if (!filter.isLiquidValid(fluid)) continue;
            return true;
        }
        return false;
    }

    @Override
    public IProgWidget.WidgetDifficulty getDifficulty() {
        return IProgWidget.WidgetDifficulty.EASY;
    }

    @Override
    public List<Component> getExtraStringInfo() {
        return Collections.singletonList(this.asTextComponent());
    }

    private Component asTextComponent() {
        return this.fluid != Fluids.f_76191_ ? new FluidStack(this.fluid, 1).getDisplayName() : PneumaticCraftUtils.xlate("pneumaticcraft.gui.progWidget.liquidFilter.noFluid", new Object[0]);
    }

    public void setFluid(Fluid fluid) {
        this.fluid = fluid;
    }

    public Fluid getFluid() {
        return this.fluid;
    }

    @Override
    public DyeColor getColor() {
        return DyeColor.RED;
    }
}

